'use strict'

entityRegistry['module']['mirror'] = {
    extendedInfo: {
        displayName: 'Mirror',
        displayGroup: 'Post Processing',
    },
    init: (staticConfig) => {
         return {
         }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'mode', displayName: 'Mode', type: 'string', defaultValue: 'xy', uiOptions: { options: [{text:'X',value:'x'}, {text:'Y',value:'y'}, {text:'XY',value:'xy'}]}},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                mode,
            } = { ...config }

            const depthBuffer = renderer.getCurrentBuffer('depth')
            const bufferWidth = depthBuffer.width
            const bufferHeight = depthBuffer.height
            const bufferHalfWidth = depthBuffer.width
            const bufferHalfHeight = depthBuffer.height

            function doBufferY (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < bufferHalfHeight; ++y) {
                    let iSrc = y*bufferWidth
                    let iDst = (bufferHeight-1-y)*bufferWidth
                    for (let x = 0; x < bufferWidth; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc] = v
                        dstBuffer[iDst] = v
                        iSrc++
                        iDst++
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            function doBufferX (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < bufferHeight; ++y) {
                    let iSrc = y*bufferWidth
                    let iDst = iSrc+bufferWidth-1
                    for (let x = 0; x < bufferHalfWidth; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc] = v
                        dstBuffer[iDst] = v
                        iSrc++
                        iDst--
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            function doBufferXY (bufferName) {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data
                for (let y = 0; y < bufferHalfHeight; ++y) {
                    let iSrc = y*bufferWidth
                    let iDst1 = iSrc+bufferWidth-1
                    let iDst2 = (bufferHeight-1-y)*bufferWidth
                    let iDst3 = iDst2+bufferWidth-1
                    for (let x = 0; x < bufferHalfWidth; ++x) {
                        const v = srcBuffer[iSrc]
                        dstBuffer[iSrc++] = v
                        dstBuffer[iDst1--] = v
                        dstBuffer[iDst2++] = v
                        dstBuffer[iDst3--] = v
                    }
                }
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            if (mode === 'x') {
                doBufferX('color')
                doBufferX('brightness')
                doBufferX('depth')
                } else if (mode === 'y') {
                doBufferY('color')
                doBufferY('brightness')
                doBufferY('depth')
            } else {
                doBufferXY('color')
                doBufferXY('brightness')
                doBufferXY('depth')
                }
        }
    }
}
